/* The module exports a function `dpr` that calculates scaling based on screen dimensions. It imports the `round` function from another file and the `Dimensions` and `StatusBar` modules from `react-native`.*/ 

import { Dimensions, StatusBar } from 'react-native';
import { round } from "../../../helper/ratingRound";


const { height, width } = Dimensions.get('screen');
const statusBarHeight = StatusBar.currentHeight || 0;

// Define width and height thresholds for scaling
const widthThresholds = [
  { limit: 400, divisor: 313 },
  { limit: 385, divisor: 315 },
  { limit: 370, divisor: 317 },
  { limit: 355, divisor: 319 },
  { limit: 340, divisor: 321 },
  { limit: 325, divisor: 323 },
  { limit: 310, divisor: 325 },
  { limit: 0, divisor: 327 }, // Default case
];

const heightThresholds = [
  { limit: 800, divisor: 860 },
  { limit: 750, divisor: 810 },
  { limit: 700, divisor: 760 },
  { limit: 650, divisor: 710 },
  { limit: 600, divisor: 660 },
  { limit: 550, divisor: 610 },
  { limit: 0, divisor: 610 }, // Default case
];

// Utility function to get the scaling divisor based on thresholds
const getDivisor = (size, thresholds) => {
  return thresholds.find(({ limit }) => size > limit).divisor;
};

// Scaling logic based on screen width
const scaleWidth = (size) => {
  const divisor = getDivisor(width, widthThresholds);
  return round((size / divisor) * width);
};

// Scaling logic based on screen height
const scaleHeight = (size) => {
  const divisor = getDivisor(height, heightThresholds);
  return round((size / divisor) * height);
};

// Main scaling function
const dpr = (size, dimensions = 'h') => {
  if (size === 'wf') return width;
  if (size === 'hf') return round(height);
  if (size === 'hwh') return round(height - (height * 0.08195 + statusBarHeight));

  return dimensions === 'w' ? scaleWidth(size) : scaleHeight(size);
};

export default dpr;